﻿' Ten kod pochodzi z książki "ASP.NET 2.0. Gotowe rozwiązania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej książce jest dostępna na stronie www.wrox.com.  
' Odwiedź p2p.wrox.com aby podyskutować o tym kodzie na forach Wrox.

Imports System
Imports System.Data
Imports System.Web.Caching

''' <summary>
''' Klasa ListManager zajmuje się prostymi listami dziedzinowymi, jest używana dla takich list jak Frequency, Status itd.
''' Zajmuje się również bardziej specyficznymi typami, jak Applications i Features.
''' </summary>
Public Class ListManager

#Region "Konstruktor(y)"

  Private Sub New()
    ' Ukryj konstruktor ponieważ klasa ma tylko składniki o dostępie współdzielonym.
  End Sub

#End Region

#Region "Metody publiczne"

#Region "Metody dla aplikacji"
  ''' <overloads>Zwraca DataSet rekordów Application z bazy danych.</overloads>
  ''' <summary>
  ''' Zwraca DataSet z wszystkimi aktywnymi rekordami Application z bazy danych.
  ''' </summary>
  ''' <returns>DataSet zawierający całość rekordu Application. DataSet zawiera tabelę z dwiema kolumnami: Id i Description.</returns>
  Public Shared Function GetApplicationItems() As DataSet
    Return GetApplicationItems(True, Guid.Empty)
  End Function

  ''' <summary>
  ''' Zwraca DataSet z wszystkimi aktywnymi rekordami Application z bazy danych.
  ''' </summary>
  ''' <returns>DataSet zawierający całość rekordu Application. DataSet zawiera tabelę z dwiema kolumnami: Id i Description.</returns>
  Public Shared Function GetApplicationItems(ByVal memberId As Guid) As DataSet
    Return GetApplicationItems(True, memberId)
  End Function

  ''' <summary>
  ''' Zwraca DataSet z wszystkimi aktywnymi lub niekatywnymi rekordami Application z bazy danych.
  ''' </summary>
  ''' <param name="activeOnly">Określa czy mają być zwracane tylko aktywne (wartość true) czy też wszystkie (false) aplikacje.</param>
  ''' <returns>DataSet zawierający całość rekordu Application. DataSet zawiera tabelę z dwiema kolumnami: Id i Description.</returns>
  Public Shared Function GetApplicationItems(ByVal activeOnly As Boolean, ByVal memberId As Guid) As DataSet
    Return ListManagerDB.GetApplicationItems(activeOnly, memberId)
  End Function

  ''' <summary>
  ''' Zwraca obiekt Description zawierający opis aplikacji na podstawie jej identyfikatora
  ''' </summary>
  ''' <returns>DataSet zawierający całość rekordu Description. DataSet zawiera tabelę z dwiema kolumnami: Id i Description.</returns>
  Public Shared Function GetApplicationDescription(ByVal applicationId As Integer) As String
    Return ListManagerDB.GetApplicationDescription(applicationId)
  End Function

#End Region

#Region "Metody dla funkcji aplikacji"
  ''' <summary>
  ''' Zwraca DataSet a wszystkimi aktywnymi rekordami Feature z bazy danych.
  ''' </summary>
  ''' <returns>DataSet zawierający wszystkie Features. DataSet zawiera tabelę z dwiema kolumnami: Id i Description.</returns>
  Public Shared Function GetFeatureItems(ByVal applicationId As Integer) As DataSet
    Dim listItems As DataSet
    Dim cacheKey As String = "FeaturesFor" + applicationId.ToString() + "DataSet"
    Dim tableName As String = "Feature"

    Dim SqlDep As SqlCacheDependency = Nothing

    If HttpContext.Current.Cache(cacheKey) Is Nothing Then
      ' Musimy stworzyć (ponownie) dane i zachować je w buforze
      listItems = ListManagerDB.GetFeatureItems(applicationId)

      Try
        ' Tworzy nowy obiekt SqlCacheDependency. 
        SqlDep = New SqlCacheDependency(AppConfiguration.DatabaseName, tableName)

      Catch exDNEFNE As DatabaseNotEnabledForNotificationException
        ' Obsługuje wyjatek DatabaseNotEnabledForNotificationException 
        ' Ojej. Nie mamy pozwolenia na stworzenie zależności. Zgłoś wyjątek ponownie, żeby był obsłużony
        ' przez kod z pliku Global.asax
        Throw

      Catch exTNEFNE As TableNotEnabledForNotificationException
        ' Obsługuje wyjątek TableNotEnabledForNotificationException
        ' Kiedy wydarzy się ten błąd, możemy próbować umożliwić powiadomienie w sposób programowy
        Throw
      Finally
        ' Jeśli doszliśmy do tego miejsca, to wiemy, że umożliwiono bazie danych i tabeli buforowanie danych
        HttpContext.Current.Cache.Insert(cacheKey, listItems, SqlDep)
      End Try
    Else
      listItems = CType(HttpContext.Current.Cache(cacheKey), DataSet)
    End If

    Return listItems

  End Function


#End Region

#Region "Metody dla innych ogólnych typów list"

  ''' <summary>
  ''' Zwraca DataSet z wszystkimi aktywnymi rekordami Frequency z bazy danych.
  ''' </summary>
  ''' <returns>DataSet zawierający całość rekordu Frequency. DataSet zawiera tabelę z dwiema kolumnami: Id i Description.</returns>
  Public Shared Function GetFrequencyItems() As DataSet
    Return GetListItems(ListType.Frequency)
  End Function

  ''' <summary>
  ''' Zwraca DataSet z wszystkimi rekordami Reproducibility z bazy danych.
  ''' </summary>
  ''' <returns>DataSet zawierający całość rekordu Reproducibility. DataSet zawiera tabelę z dwiema kolumnami: Id i Description.</returns>
  Public Shared Function GetReproducibilityItems() As DataSet
    Return GetListItems(ListType.Reproducibility)
  End Function

  ''' <summary>
  ''' Zwraca DataSet z wszystkimi rekordami Severity z bazy danych.
  ''' </summary>
  ''' <returns>DataSet zawierający całość rekordu Severity. DataSet zawiera tabelę z dwiema kolumnami: Id i Description.</returns>
  Public Shared Function GetSeverityItems() As DataSet
    Return GetListItems(ListType.Severity)
  End Function


  ''' <summary>
  ''' Zwraca DataSet z wszystkimi rekordami Status z bazy danych.
  ''' </summary>
  ''' <returns>DataSet zawierający całość rekordu Status. DataSet zawiera tabelę z dwiema kolumnami: Id i Description.</returns>
  Public Shared Function GetStatusItems() As DataSet
    Return GetListItems(ListType.Status)
  End Function

  ''' <summary>
  ''' Prywatna metoda pomocnicza pobierająca żądane elementy z bufora lub z bazy danych.
  ''' </summary>
  ''' <param name="myListType">Typ żądanej listy.</param>
  ''' <returns>A DataSet zawierający żądane elementy. DataSet zawiera tabelę z dwiema kolumnami: Id i Description.</returns>
  Private Shared Function GetListItems(ByVal myListType As ListType) As DataSet
    Dim listItems As DataSet
    Dim cacheKey As String = myListType.ToString() + "DataSet"
    Dim tableName As String = myListType.ToString()

    Dim SqlDep As SqlCacheDependency = Nothing

    If HttpContext.Current.Cache(myListType.ToString() _
        + "DataSet") IsNot Nothing Then
      listItems = CType(HttpContext.Current.Cache(cacheKey), DataSet)
    Else
      ' Musimy stworzyć (ponownie) dane i zachować je w buforze
      listItems = ListManagerDB.GetListItems(myListType)

      Try
        ' Tworzy nowy obiekt SqlCacheDependency. Uzywamy myListType.ToString() jako klucza dla buforowanego elementu
        SqlDep = New SqlCacheDependency( _
            AppConfiguration.DatabaseName, tableName)

      Catch exDNEFNE As DatabaseNotEnabledForNotificationException
        ' Obsługuje wyjątek DatabaseNotEnabledForNotificationException 
        ' Ojej. Nie mamy pozwolenia na stworzenie zależności. Zgłoś wyjątek ponownie, żeby był obsłużony
        ' przez kod z pliku Global.asax
        Throw

      Catch exTNEFNE As TableNotEnabledForNotificationException
        ' Obsługuje wyjątek TableNotEnabledForNotificationException
        ' Kiedy wydarzy się ten błąd, możemy próbować umożliwić powiadomienie w sposób programowy
        Throw
      Finally
        ' Jeśli doszliśmy do tego miejsca, to wiemy, że umożliwiono bazie danych i tabeli buforowanie danych
        HttpContext.Current.Cache.Insert(cacheKey, listItems, SqlDep)
      End Try
    End If

    Return listItems

  End Function
#End Region

#End Region

End Class